/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusAps_Public.h 59617 2016-03-07 08:00:35Z RalfH $

Description:
  This file contains definitions of the packet interface to Profibus ApS task

Changes:
  Date          Description
  -----------------------------------------------------------------------------------
  2015-01-14    created
**************************************************************************************/
#ifndef __PROFIBUS_APS_PUBLIC_H
#define __PROFIBUS_APS_PUBLIC_H

/***************************************************************************************/
/* Profibus Aps public, constants */
#define PROFIBUS_APS_PROCESS_QUEUE_NAME   "PB_APS_QUE"


/* definitions for the warmstart prm command */

/* Warmstart System Flags */
#define WRMSTRT_FLG_START_MSK            0x00000001
#define WRMSTRT_FLG_START_APPLICATION    0x00000001
#define WRMSTRT_FLG_START_AUTO           0x00000000

#define WRMSTRT_FLG_IOSTAT_ENABLE_MSK    0x00000002
#define WRMSTRT_FLG_IOSTAT_ENABLED_MSK   0x00000002
#define WRMSTRT_FLG_IOSTAT_DISABLED_MSK  0x00000000

#define WRMSTRT_FLG_IOSTAT_LEN_MSK       0x00000004
#define WRMSTRT_FLG_IOSTAT_LEN_8BIT      0x00000004
#define WRMSTRT_FLG_IOSTAT_LEN_32BIT     0x00000000

#define WRMSTRT_FLG_ADR_SW_MSK           0x00000010
#define WRMSTRT_FLG_ADR_SW_ENABLE        0x00000010
#define WRMSTRT_FLG_ADR_SW_DISABLE       0x00000000



/* Flags */
#define WRMSTRT_FLG_DPV1_ENABLE     0x01
#define WRMSTRT_FLG_SYNC_SUPP       0x02
#define WRMSTRT_FLG_FREEZE_SUPP     0x04
#define WRMSTRT_FLG_FAILSAFE_SUPP   0x08
#define WRMSTRT_FLG_NO_ALARM_SUPP   0x10
#define WRMSTRT_FLG_IO_SWAP         0x20
#define WRMSTRT_FLG_AUTOCONFIG      0x40
#define WRMSTRT_FLG_NO_ADDR_CHANGE  0x80

#define PROFIBUS_APS_MAX_CFG_DATA_SIZE   244

#define PROFIBUS_APS_RESERVED_3100            0x00003100
#define PROFIBUS_APS_RESERVED_3101            0x00003101

#define PROFIBUS_APS_SET_CONFIGURATION_REQ    0x00003102
#define PROFIBUS_APS_SET_CONFIGURATION_CNF    0x00003103

#define PROFIBUS_APS_CHECK_USER_PRM_IND       0x00003104
#define PROFIBUS_APS_CHECK_USER_PRM_RES       0x00003105

#define PROFIBUS_APS_CHECK_CFG_IND            0x00003106
#define PROFIBUS_APS_CHECK_CFG_RES            0x00003107

#define PROFIBUS_APS_GET_USER_PRM_REQ         0x00003108
#define PROFIBUS_APS_GET_USER_PRM_CNF         0x00003109

#define PROFIBUS_APS_GET_CFG_REQ              0x0000310A
#define PROFIBUS_APS_GET_CFG_CNF              0x0000310B


/* reserved Area */

/* 0x000031F0 - 0x000031FF */

/***************************************************************************************/
/* Profibus Aps public, types */



/***************************************************************************************/
/* Profibus Aps public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(PROFIBUS_APS_PUBLIC)
#endif


#define PROFIBUS_APS_ALARM_MODE_DEFAULT 0x00 /* support all alarm modes */
#define PROFIBUS_APS_ALARM_MODE_NO_SEQ  0x02 /* only support unsequenced alarm mode */

  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_SET_CONFIGURATION_REQ_Ttag {
    TLR_UINT32  ulSystemFlags; /* reserved for IO status */
    TLR_UINT32  ulWdgTime;

    TLR_UINT16  usIdentNumber;
    TLR_UINT8   bBusAddr;
    TLR_UINT8   bBaudRate;
    TLR_UINT8   bFlags;
    TLR_UINT8   bRes[2];
    TLR_UINT8   bCfgLen;
    TLR_UINT8   abCfgData[PROFIBUS_APS_MAX_CFG_DATA_SIZE];
  }__TLR_PACKED_POST PROFIBUS_APS_SET_CONFIGURATION_REQ_T;

   #define PROFIBUS_APS_SET_CONFIGURATION_REQ_SIZE (sizeof(PROFIBUS_APS_SET_CONFIGURATION_REQ_T)-244)

 /* Indication Packet for acknowledged connectionless data transfer */
  typedef struct  PROFIBUS_APS_PACKET_SET_CONFIGURATION_REQ_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_SET_CONFIGURATION_REQ_T tData;
  } PROFIBUS_APS_PACKET_SET_CONFIGURATION_REQ_T;


   #define PROFIBUS_APS_SET_CONFIGURATION_CNF_SIZE 0

 /* Indication Packet for acknowledged connectionless data transfer */
  typedef struct  PROFIBUS_APS_PACKET_SET_CONFIGURATION_CNF_Ttag {
    TLR_PACKET_HEADER_T tHead;
  } PROFIBUS_APS_PACKET_SET_CONFIGURATION_CNF_T;


  /* check user parameter indication */
  #define PROFIBUS_APS_MAX_USER_PRM_DATA_SIZE   237
  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_CHECK_USER_PRM_IND_Ttag {
    TLR_UINT8 abUserPrmData[PROFIBUS_APS_MAX_USER_PRM_DATA_SIZE];
  }__TLR_PACKED_POST PROFIBUS_APS_CHECK_USER_PRM_IND_T;

  typedef struct  PROFIBUS_APS_PACKET_CHECK_USER_PRM_IND_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_CHECK_USER_PRM_IND_T tData;
  } PROFIBUS_APS_PACKET_CHECK_USER_PRM_IND_T;


  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_CHECK_USER_PRM_RES_Ttag {
    TLR_BOOLEAN8 fPrmOk;
  }__TLR_PACKED_POST PROFIBUS_APS_CHECK_USER_PRM_RES_T;

  #define PROFIBUS_APS_CHECK_USER_PRM_RES_SIZE sizeof(PROFIBUS_APS_CHECK_USER_PRM_RES_T);

  typedef struct  PROFIBUS_APS_PACKET_CHECK_USER_PRM_RES_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_CHECK_USER_PRM_RES_T tData;
  } PROFIBUS_APS_PACKET_CHECK_USER_PRM_RES_T;

  /* check configuration indication */
  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_CHECK_CFG_IND_Ttag {
  TLR_UINT8 abCfgData[PROFIBUS_APS_MAX_CFG_DATA_SIZE]; /* Configuration data that needs to be checked */
  }__TLR_PACKED_POST PROFIBUS_APS_CHECK_CFG_IND_T;

  typedef struct PROFIBUS_APS_PACKET_CHECK_CFG_IND_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_CHECK_CFG_IND_T tData;
  } PROFIBUS_APS_PACKET_CHECK_CFG_IND_T;


  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_CHECK_CFG_RES_Ttag {
    TLR_BOOLEAN8 fCfgOk;
  }__TLR_PACKED_POST PROFIBUS_APS_CHECK_CFG_RES_T;

  #define PROFIBUS_APS_CHECK_CFG_RES_SIZE sizeof(PROFIBUS_APS_CHECK_CFG_RES_T);

  typedef struct  PROFIBUS_APS_PACKET_CHECK_CFG_RES_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_CHECK_CFG_RES_T tData;
  } PROFIBUS_APS_PACKET_CHECK_CFG_RES_T;

  /* get user parameter data */
  #define PROFIBUS_APS_GET_USER_PRM_REQ_SIZE 0

  typedef struct  PROFIBUS_APS_PACKET_GET_USER_PRM_REQ_Ttag {
    TLR_PACKET_HEADER_T tHead;
  } PROFIBUS_APS_PACKET_GET_USER_PRM_REQ_T;


  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_GET_USER_PRM_CNF_Ttag {
    TLR_UINT8 abUserPrmData[PROFIBUS_APS_MAX_USER_PRM_DATA_SIZE];
  }__TLR_PACKED_POST PROFIBUS_APS_GET_USER_PRM_CNF_T;

  typedef struct  PROFIBUS_APS_PACKET_GET_USER_PRM_CNF_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_GET_USER_PRM_CNF_T tData;
  } PROFIBUS_APS_PACKET_GET_USER_PRM_CNF_T;

  /* get configuration data */
  #define PROFIBUS_APS_GET_CFG_REQ_SIZE 0

  typedef struct PROFIBUS_APS_PACKET_GET_CFG_REQ_Ttag {
    TLR_PACKET_HEADER_T tHead;
  } PROFIBUS_APS_PACKET_GET_CFG_REQ_T;


  typedef __TLR_PACKED_PRE struct PROFIBUS_APS_GET_CFG_CNF_Ttag {
    TLR_UINT8 abCfgData[PROFIBUS_APS_MAX_CFG_DATA_SIZE];
  }__TLR_PACKED_POST PROFIBUS_APS_GET_CFG_CNF_T;

  typedef struct  PROFIBUS_APS_PACKET_GET_CFG_CNF_Ttag {
    TLR_PACKET_HEADER_T tHead;
    PROFIBUS_APS_GET_CFG_CNF_T tData;
  } PROFIBUS_APS_PACKET_GET_CFG_CNF_T;





/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(PROFIBUS_APS_PUBLIC)
#endif



/***************************************************************************************/
/* Profibus Aps public, prototypes */


/***************************************************************************************/
#endif /* #ifndef __PROFIBUS_APS_PUBLIC_H */
